#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Geometry WarpMod01.fsh  by  mla
//https://www.shadertoy.com/view/Wt3fz8
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

////////////////////////////////////////////////////////////////////////////////
//
// Geometry Warp, Matthew Arcus, mla, 2021
//
// Smooth transition between Euclidean,  Hyperbolic and Spherical geometry.
//
// Mouse moves centre point (with an isometry in the appropriate geometry). 
//
// Uses hyperboloid model for hyperbolic geometry.
// 
// k controls the geometry - use a sphere or hyperboloid of radius 1/sqrt(|k|),
// with inner product x^2+y^2+sign(k)*z^2. For k = 0 (the Euclidean case),
// the radius is infinite and we use some asymptotic approximations.
// 
////////////////////////////////////////////////////////////////////////////////
// prevoid common  //
////////////////////////////////////////////////////////////////////////////////

float PI = 3.14159;

// From Chris Wellons: https://nullprogram.com/blog/2018/07/31/
uint ihash(uint x) {
    x ^= x >> 16;
    x *= 0x7feb352dU;
    x ^= x >> 15;
    x *= 0x846ca68bU;
    x ^= x >> 16;
    return x;
}

float fhash(vec2 index) {
  uint h = ihash(uint(int(index.x))^ihash(uint(int(index.y))));
  return float(h)/exp2(32.0);
}

vec3 h2rgb(float h) {
  vec3 rgb = clamp( abs(mod(h*6.0+vec3(0.0,4.0,2.0),6.0)-3.0)-1.0, 0.0, 1.0 );
  //rgb *= rgb*(3.0-2.0*rgb); // cubic smoothing	
  return rgb;
}

vec2 rotate(vec2 p, float t) {
  return cos(t)*p + sin(t)*vec2(-p.y,p.x);
}
//end prevoid common  //

// Stereographic projection from (0,0,-R) to z = 0, where R^2 = |1/k|
vec3 project(vec2 p, float k) {
  float t = 2.0/(1.0+k*dot(p,p));
  return vec3(t*p,(t-1.0)/sqrt(abs(k)));
}

// Inner product
float kdot(vec3 p, vec3 q, float k) {
  return dot(p*vec3(1,1,sign(k)),q);
}

vec3 diagram(vec2 p2, vec2 q2) {
  p2 = rotate(p2,iTime);
  q2 = rotate(q2,iTime);
  float k = -sin(0.5*iTime);
  float R = 1.0/sqrt(abs(k)); // Sphere or hyperboloid radius
  vec3 p = project(p2,k);
  vec3 q = project(q2,k); // Mouse position
  vec3 r = vec3(0,0,R);
  vec3 n = q+r; // This reflects q to -r & then flipping z coord takes us to N. pole
  p -= k == 0.0 ? n : 2.0*kdot(p,n,k)/kdot(n,n,k)*n; // Asymptotic value for k = 0
  p.z = -p.z;
  float s = length(p.xy);
  // Calculate distance from centre
  // For small x, atanh(x) = atan(x) = x and for small k, p.z = R
  float d = abs(k) < 1e-4 ? s : R*(k < 0.0 ? atanh(s/p.z) : atan(s/abs(p.z)));
  vec2 uv = vec2(16.0*d,12.0*atan(p.y,p.x));
  uv /= 2.0*PI;
  vec2 index = floor(uv);
  uv -= index;
  uv *= 2.0*PI;
  vec3 col = h2rgb(fhash(index));
  col *= (0.5-0.5*cos(uv.x))*(0.5-0.5*cos(uv.y));
  if (k < 0.0) {
    col = mix(vec3(0),col,smoothstep(0.0,0.05,R-length(p2)));
    col = mix(vec3(0.2),col,smoothstep(-0.01,0.0,R-length(p2)));
  }
  return col;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
  vec2 p = (2.0*fragCoord-iResolution.xy)/iResolution.y;
  vec2 q = vec2(-0.75,-0.25);
  if (iMouse.x > 0.0) q = (2.0*iMouse.xy-iResolution.xy)/iResolution.y;
  vec3 col = diagram(p,q);
  col = pow(col,vec3(0.4545));
  fragColor = vec4(col,1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

